% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_knit_item_content.R
\name{prereg_knit_item_content}
\alias{prereg_knit_item_content}
\title{Knit the specified content for the items in a (pre)registration into an Rmd file}
\usage{
prereg_knit_item_content(x, section = NULL, headingLevel = 2)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{section}{The section(s) to show; pass \code{NULL} (the default) to show
everything.}

\item{headingLevel}{The level to use for the top-most heading.}
}
\value{
x, invisibly
}
\description{
This function inserts the specified content for the items in a
(pre)registration, or in one or more sections, into an R Markdown file.
}
\examples{
examplePreReg <-
  preregr::prereg_initialize(
    "inclSysRev_v0_92"
  ) |>
    preregr::prereg_specify(
      title = "Example Study",
      authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
      nonExistent_item = "This can't be stored anywhere"
    ) |>
    preregr::prereg_knit_item_content(
      section="metadata"
    );
}
