% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_html.R
\name{import_from_html}
\alias{import_from_html}
\title{Import a (pre)registration specification from JSON embedded in HTML}
\usage{
import_from_html(x, select = 1)
}
\arguments{
\item{x}{The HTML as URL, path to a file, or HTML that has already
been imported to a character vector.}

\item{select}{If multiple \code{preregr} specifications are present in \code{x},
the \code{select} argument can be used to select which one to import. \code{select}
is a number corresponding to the order of the encountered \code{preregr}
specifications (e.g., pass \code{2} to import the second specification, etc).}
}
\value{
The (pre)registration specification.
}
\description{
Import a (pre)registration specification from JSON embedded in HTML
}
\examples{
### Don't run this example because it takes quite long
### and writed to a local file
\dontrun{
### Temporary file to save to
tmpFile <- tempfile(fileext = ".html");

### Create example preregistration
preregrExample <-
  preregr::prereg_initialize(
    "inclSysRev_v0_92"
  ) |>
  preregr::prereg_specify(
    title = "Example Study",
    authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
    nonExistent_item = "This can't be stored anywhere"
  ) |>
  preregr::prereg_justify(
    item = "primary_research_question",
    content = "Example content",
    decision = "decision ...",
    justification = "justification ..."
  );

### Save it to an HTML file
preregr::prereg_spec_to_html(
  preregrExample,
  file = tmpFile
);

### Import the example again
importedPreregr <-
  preregr::import_from_html(
    tmpFile
  );

### Show the result
preregr::prereg_show_item_completion(
  importedPreregr,
  section="metadata"
);
}
}
