% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PreProCombClass.R
\name{preprocomb}
\alias{preprocomb}
\title{the MAIN function of programmatic use.}
\usage{
preprocomb(models = "rpart", gridclassobject, nholdout = 2,
  searchmethod = "exhaustive", predict = TRUE, cluster = FALSE,
  outlier = FALSE, cores = 1)
}
\arguments{
\item{models}{(character) vector of models (names of models as defined in package caret), defaults to "rpart"}

\item{gridclassobject}{(GridClass) object representing the grid of combinations}

\item{nholdout}{(integer) number of holdout rounds for predictive classification, must be two or more, defaults to two}

\item{searchmethod}{(character) defaults to "exhaustive" full blind search, "random" search 20 percent of grid, "grid" grid search 10 percent}

\item{predict}{(boolean) compute predictions, defaults to TRUE}

\item{cluster}{(boolean) compute clustering tendency, defaults to FALSE}

\item{outlier}{(boolean) compute outlier tendency, defaults to FALSE}

\item{cores}{(integer) number of cores used in parallel processing of holdout rounds, defaults to 1}
}
\value{
a PreProCombClass object
}
\description{
preprocomb executes the computation of classification accuracy, hopkins statistic and ORH outlier score.
An alternative to preprocomb is to use package 'metaheur' for faster finding of near-optimal combinations.
}
\details{
caret messages will be displayed during processing
}
\examples{
## modifiediris <- droplevels(iris[-c(1:60),])
## grid <- setgrid(phases=c("outliers", "scaling"), data=modifiediris)
## library(kernlab)
## result <- preprocomb(models=c("svmRadial"), grid=grid, nholdout=1, search="grid")
## result@allclassification
## result@allclustering
## result@alloutliers
## result@rawall
## result@catclassification
##
## newphases <- c("outliers", "smoothing", "scaling", "selection", "sampling")
## newmodels <- c("knn", "rf", "svmRadial")
## grid1 <- setgrid(phases=newphases, data=modifiediris)
## result1 <- preprocomb(models=newmodels, grid=grid1, nholdout=1, search="grid")
}

