% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PreProCombClass.R
\name{preprocomb}
\alias{preprocomb}
\title{preprocomb}
\usage{
preprocomb(models, grid, nholdout = 2, search = "exhaustive")
}
\arguments{
\item{models}{(character) vector of models (names of models as defined in package caret), there must be an odd number of models}

\item{grid}{(GridClass) object representing the grid of combinations}

\item{nholdout}{(integer) number of holdout rounds, must be two or more, defaults to two}

\item{search}{(character) defaults to "exhaustive" full blind search, "random" search 20 percent of grid, "grid" grid search 10 percent}
}
\value{
a PreProCombClass object
}
\description{
preprocomb the main function of programmatic use. It executes the computation of
classification accuracy, hopkins statistic and ORH outlier score. See also
PreProCombClass.
}
\details{
caret messages will be displayed during processing
}
\examples{
## modifiediris <- droplevels(iris[-c(1:60),])
## grid <- setgrid(phases=c("outlier", "scaling"), data=modifiediris)
## library(kernlab)
## result <- preprocomb(models=c("svmRadial"), grid=grid, nholdout=2, search="exhaustive")
## result@allclassification
## result@allclustering
## result@alloutliers
## result@rawall
## result@catclassification
##
## newphases <- c("outlier", "smoothing", "scaling", "selection", "sampling")
## newmodels <- c("knn", "rf", "svmRadial")
## grid1 <- setgrid(phases=newphases, data=modifiediris)
## result1 <- preprocomb(models=newmodels, grid=grid1, nholdout=2, search="grid")
}

