## ----message=F,warning=F-------------------------------------------------
if (!require(devtools)) install.packages("devtools", repos="https://cloud.r-project.org")
library(devtools)
install_github("kaneplusplus/preference")
library(preference)

## ------------------------------------------------------------------------
effects_from_means(mu1=46, mu2=45, mu11=50, mu22=49, phi=0.7)

## ------------------------------------------------------------------------
overall_sample_size(power=0.8, phi=0.7, sigma2=5, delta_pi=9.52, delta_nu=3.81, delta_tau=1)

## ------------------------------------------------------------------------
effects_from_means(mu1=c(52,42), mu2=c(50,42), mu11=c(54,46), mu22=c(52,44), phi=c(0.5,0.7), nstrata=2, xi=c(0.4,0.6))

## ------------------------------------------------------------------------
overall_sample_size(power=0.8, phi=c(0.5,0.7), sigma2=c(3,4), delta_pi=7.67, delta_nu=3.67, delta_tau=1, xi=c(0.4,0.6), nstrata=2)

## ------------------------------------------------------------------------
overall_power(N=212, phi=0.7, sigma2=5, delta_pi=9.52, delta_nu=3.81, delta_tau=1)

## ------------------------------------------------------------------------
overall_power(N=212, phi=c(0.5,0.7), sigma2=c(3,4), delta_pi=7.67, delta_nu=3.67, delta_tau=1, xi=c(0.4,0.6), nstrata=2)

## ------------------------------------------------------------------------
optimal_proportion(w_sel=1/3, w_pref=1/3, w_treat=1/3, sigma2=5, phi=0.7, delta_pi=9.52, delta_nu=3.81)

## ------------------------------------------------------------------------
imap

## ------------------------------------------------------------------------
effects_from_means(mu1=46.16386, mu2=45.51061, mu11=47.57283, mu22=50.58991, phi=50/(50+22))

## ------------------------------------------------------------------------
analyze_summary_data(x1mean=47.57283, x1var=10.6162889^2, m1=50, 
                     x2mean=50.58991, x2var=4.8686232^2, m2=22, 
                     y1mean=46.16386, y1var=9.7385777^2, n1=76, 
                     y2mean=45.51061, y2var=9.9744353^2, n2=64)

## ------------------------------------------------------------------------
imap_strat

## ------------------------------------------------------------------------
mu1=c(52.00437,42.17970)
mu2=c(53.84277,41.14614)
mu11=c(54.33376,41.00851)
mu22=c(51.50413,49.89651)
phi=c(24/(24+10),25/(25+11))
xi=c((24+10+30+22)/208,(25+11+44+42)/208)
effects_from_means(mu1, mu2, mu11, mu22, phi, nstrata=2, xi)

## ------------------------------------------------------------------------
x1mean=c(54.33376,41.00851)
x1var=c(5.5, 10.5)
m1=c(24,25)
x2mean=c(51.50413,49.89651)
x2var=c(6.1, 3.8)
m2=c(10,11)
y1mean=c(52.00437,42.17970)
y1var=c(6.6, 9.6)
n1=c(30,44)
y2mean=c(53.84277,41.14614)
y2var=c(5.3,9.1)
n2=c(22,42)
xi=c((24+10+30+22)/208,(25+11+44+42)/208)
analyze_summary_data(x1mean, x1var, m1, x2mean, x2var, m2, y1mean, y1var, n1, y2mean, y2var, n2, xi, nstrata=2)

