% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.rai.r
\name{pplot.rai}
\alias{pplot.rai}
\alias{precintcon.plot.rai}
\title{Plot Rainfall Anomaly Index}
\usage{
pplot.rai(\dots, granularity = "m", xlab = "Month", ylab = "RAI",
					 ylim = c(-3,3), legend = NULL, fontsize = 10,
                axis.text.color = "black", export = FALSE,
					 export.name = "rai_plot.png", width = 8.6,
					    height = 7.5, units = "cm")
}
\arguments{
\item{granularity}{the granularity applied for calculating the rainfall
anomaly index, which should be either "a" for annual granularity or "m" for
monthly granularity ". (Default value: "m")}

\item{xlab}{the text for the x axis. (Default value: "Month")}

\item{ylab}{the text for the y axis. (Default value: "RAI")}

\item{ylim}{the limits of the y axis. (Default value: c(-3, 3))}

\item{legend}{the text vector for the legend items. If NULL the legends will
be equals to the variable names. (Default value: NULL)}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{export}{the logical value for defining whether the graph should be export
to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only used
if export = TRUE. (Default value: "rai_plot.png")}

\item{width}{the number for defining the exported graph width. It is only used if
export = TRUE. (Default value: 8.6)}

\item{height}{the number for defining the exported graph height. It is only used
if export = TRUE. (Default value: 7.5)}

\item{units}{the text for defining the units of the height and width parameters.
It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily or monthly precipitation series.}
}
\description{
Plots the Rainfall Anomaly Index of a precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the a set of statistical analysis
pplot.rai(daily, granularity = "m")
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
}
\keyword{anomaly}
\keyword{precipitation}
\keyword{rainfall}

