% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_interface.R
\name{create_usrtool}
\alias{create_usrtool}
\title{Create a set of tools}
\usage{
create_usrtool(tool_name, func, calc_auc = TRUE, store_res = TRUE, x = NA,
  y = NA)
}
\arguments{
\item{tool_name}{A single string to specify the name of a user-defined tool.}

\item{func}{A function to calculate a Precision-Recall curve and the AUC. It
should take an element of the test dataset generated by
\code{\link{create_testset}} as an argument. It also should return a list
with three elements - 'x', 'y', and 'auc' that represent calculated recall
and precision values plus the AUC score.
See \code{\link{create_example_func}} for an example.}

\item{calc_auc}{A Boolean value to specify whether the AUC score should be
calculated.}

\item{store_res}{A Boolean value to specify whether the calculated curve is
retrieved and stored.}

\item{x}{Set pre-calculated recall values.}

\item{y}{Set pre-calculated precision values.}
}
\value{
A list of \code{R6} tool objects.
}
\description{
The \code{create_toolset} function takes names of predefined tools and
  generates a list of wrapper functions for Precision-Recall curve
  calculations.
}
\examples{
## Create a new tool interface called "xyz"
efunc <- create_example_func()
toolset1 <- create_usrtool("xyz", efunc)
toolset1

## Example function with a correct argument
testset <- create_usrdata("bench", scores = c(0.1, 0.2), labels = c(1, 0))
retf <- efunc(testset[[1]])
retf

}
\seealso{
\code{\link{create_toolset}} to create a predefined tool set.
 \code{\link{create_testset}} for \code{testset}.
 \code{\link{create_example_func}} to create an example function.
}
