% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcovHC.R
\name{vcovHC.prais}
\alias{vcovHC.prais}
\title{Semirobust Covariance Matrix Estimators}
\usage{
\method{vcovHC}{prais}(x, type = c("const", "HC1", "HC0"), ...)
}
\arguments{
\item{x}{an object of class \code{"prais"}, usually, the result of a call to \code{\link{prais_winsten}}.}

\item{type}{a character string specifying the estimation type.}

\item{...}{not used.}
}
\value{
An object of class "matrix" containing the estimate of the asymptotic covariance matrix
of coefficients.
}
\description{
Semirobust covariance matrix estimators for models of class \code{"prais"}.
}
\details{
\code{vcovHC} is a function for estimating a robust covariance matrix of parameters for
the Prais-Winsten estimator. The weighting schemes specified by type are analogous to those in
\code{\link[sandwich]{vcovHC}} in package \href{https://cran.r-project.org/package=sandwich}{sandwich}
with the caveat that only \code{"const"}, \code{"HC0"} and \code{"HC1"} are available.
}
\seealso{
\code{\link[sandwich]{vcovHC}}
}
