% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.parallel.bin.R
\name{crt.parallel.bin}
\alias{crt.parallel.bin}
\title{Power calculation for cluster randomized trial with binary outcome}
\usage{
crt.parallel.bin(
  m = NULL,
  m.sd = 0,
  J = NULL,
  pc = NULL,
  pt = NULL,
  sigma.u = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects per cluster.}

\item{m.sd}{The standard deviation of cluster sizes (provide if unequal number of participants per cluster); defaults to 0.}

\item{J}{The total number of clusters (over both arms).}

\item{pc}{The probability of the outcome in control clusters.}

\item{pt}{The probability of the outcome in treatment clusters.}

\item{sigma.u}{Standard deviation of the cluster random effect (random intercept).}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for a two-arm cluster randomized trial
with a binary outcome. It assumes the outcome analysis will be conducted using a mixed effect logistic
regression model that has a random intercept for cluster. Equal allocation of clusters to arms
is assumed. Can solve for power, J, m or alpha.
}
\details{
For help selecting a reasonable value for sigma.u, consider using the crt.varexplore function.
}
\examples{
crt.parallel.bin(m = 60, J = NULL, pc = 0.25, pt = 0.15, sigma.u = 0.3, power = 0.8)
crt.parallel.bin(m = 60, m.sd = 1, J = NULL, pc = 0.25, pt = 0.15, sigma.u = 0.3, power = 0.8)
}
