% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmComb.R
\name{genCombTree}
\alias{genCombTree}
\title{Generation of the comb or caterpillar tree}
\usage{
genCombTree(n)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.}
}
\value{
\code{genCombTree} A single tree of class \code{phylo} is returned.
}
\description{
\code{genCombTree} - Generates the rooted binary comb tree (also known as
caterpillar tree) in \code{phylo} format with the given number of \code{n}
leaves. \cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format
the number of leaves must be at least 2 since there must be at
least one edge.
}
\examples{
genCombTree(n = 6)
}
\references{
\itemize{
\item D. Aldous. Probability Distributions on Cladograms. In Random Discrete
Structures, pages 1–18. Springer New York, 1996.
}
}
\author{
Sophie Kersting
}
