% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drpgmiv.R, R/prpgmiv.R, R/qrpgmiv.R,
%   R/rrpgmiv.R
\name{revpgmiv}
\alias{revpgmiv}
\alias{drpgmiv}
\alias{revpgmiv}
\alias{prpgmiv}
\alias{revpgmiv}
\alias{qrpgmiv}
\alias{revpgmiv}
\alias{rrpgmiv}
\title{The Reversal Power Gumbel of Minimum Value Distribution}
\usage{
drpgmiv(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

prpgmiv(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qrpgmiv(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rrpgmiv(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the reversal power Gumbel of minimum value distribution with parameters mu, sigma and lambda.
}
\details{
The reversal power Gumbel of minimum value distribution has density

\eqn{f\left(x\right)=\frac{\lambda}{\sigma}\left[e^{-\left(-\left(\frac{x-\mu}{\sigma}\right)+e^{\left(\frac{x-\mu}{\sigma}\right)}\right)}\right]\left[1-e^{-e^{-\left(\frac{x-\mu}{\sigma}\right)}}\right]^{\lambda-1}}{f(x)=[\lambda/\sigma][exp((x-\mu)/\sigma-exp((x-\mu)/\sigma))][1-exp(-exp(-(x-\mu)/\sigma))]^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
drpgmiv(1, 1, 3, 4)
prpgmiv(1, 1, 3, 4)
qrpgmiv(0.2, 1, 3, 4)
rrpgmiv(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
