% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpl.R, R/ppl.R, R/qpl.R, R/rpl.R
\name{pl}
\alias{pl}
\alias{dpl}
\alias{pl}
\alias{ppl}
\alias{pl}
\alias{qpl}
\alias{pl}
\alias{rpl}
\title{The Power Logistic Distribution}
\usage{
dpl(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

ppl(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qpl(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rpl(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power logistic distribution with parameters mu, sigma and lambda.
}
\details{
The power Logistic distribution has density

\eqn{f\left(x\right)=\frac{\lambda}{\sigma}\left[\frac{e^{-\left(\frac{x-\mu}{\sigma}\right)}}{\left(1+e^{-\left(\frac{x-\mu}{\sigma}\right)}\right)^{2}}\right]\left[\frac{e^{\left(\frac{x-\mu}{\sigma}\right)}}{1+e^{\left(\frac{x-\mu}{\sigma}\right)}}\right]^{\lambda-1}}{f(x)=[\lambda/\sigma][exp(-(x-\mu)/\sigma)/(1+exp(-(x-\mu)/\sigma)))^2][exp((x-\mu)/\sigma)/(1+exp((x-\mu)/\sigma)]^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
dpl(1, 1, 3, 4)
ppl(1, 1, 3, 4)
qpl(0.2, 1, 3, 4)
rpl(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.

Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 16. Wiley, New York.

Nadarajah, S. (2009) The skew logistic distribution. \emph{AStA Advances in Statistical Analysis}, \strong{93}, 187-203.

Prentice, R. L. (1976) A Generalization of the probit and logit methods for dose-response curves. \emph{Biometrika}, \strong{32}, 761-768.
}
