% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpc.R, R/ppc.R, R/qpc.R, R/rpc.R
\name{pc}
\alias{pc}
\alias{dpc}
\alias{pc}
\alias{ppc}
\alias{pc}
\alias{qpc}
\alias{pc}
\alias{rpc}
\title{The Power Cauchy Distribution}
\usage{
dpc(x, lambda, mu = 0, sigma = 1)

ppc(q, lambda, mu = 0, sigma = 1)

qpc(p, lambda, mu = 0, sigma = 1)

rpc(n, lambda, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power Cauchy distribution with parameters mu, sigma and lambda.
}
\examples{
dpc(1, 1, 3, 4)
ppc(1, 1, 3, 4)
qpc(0.2, 1, 3, 4)
rpc(5, 2, 3, 4)
}
\references{
Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{http://conteudo.icmc.usp.br/pessoas/jlbazan/download/thesis.pdf}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
