% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate.powdRlib}
\alias{interpolate.powdRlib}
\title{Interpolate a \code{powdRlib} object onto a given 2theta scale.}
\usage{
\method{interpolate}{powdRlib}(x, new_tth, ...)
}
\arguments{
\item{x}{a \code{powdRlib} object.}

\item{new_tth}{a numeric vector of the new 2theta scale.}

\item{...}{other arguments}
}
\value{
a \code{powdRlib} object.
}
\description{
\code{interpolate} takes a \code{powdRlib} object and interpolates the
data onto a new 2theta scale using a cubic spline.
}
\examples{
data(minerals)

#Define a new 2theta scale:
tth <- seq(10, 60, 0.04)

#interpolate data onto new scale
i1 <- interpolate(minerals, new_tth = tth)
}
