% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate}
\alias{interpolate}
\title{Interpolate an XY, multiXY or powdRlib object to a given 2theta scale.}
\usage{
interpolate(x, new_tth, ...)
}
\arguments{
\item{x}{an \code{XY} or \code{multiXY} object.}

\item{new_tth}{a numeric vector of the new 2theta scale.}

\item{...}{other arguments}
}
\value{
an \code{XY} or \code{multiXY} object.
}
\description{
\code{interpolate} takes an XY, multiXY or powdRlib object and
interpolates the data onto a new 2theta scale using a natural spline.
See additional help via \code{?interpolate.XY},
\code{?interpolate.multiXY} or \code{?interpolate.powdRlib}.
}
\examples{
#Define a new 2theta scale:
data(rockjock_mixtures)
tth <- seq(10, 60, 0.04)

#interpolate multiXY object of data onto new scale
i1 <- interpolate(rockjock_mixtures, new_tth = tth)

#interpolate XY object onto new scale
i2 <- interpolate(rockjock_mixtures$Mix1, new_tth = tth)

#interpolate powdRlib object onto new scale
i3 <- interpolate(minerals, new_tth = tth)

}
