% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rockjock_mixtures}
\alias{rockjock_mixtures}
\title{RockJock synthetic mixtures}
\format{A list of 8 components, each comprised of two columns. Column \code{tth} specifies
the 2theta axis and \code{counts} specifies the count intensities
\describe{
\item{Mix1}{Contains: 4 \% K-feldspar, 20 \% plagioclase, 12 \% kaolinite, 36 \% dioctahedral
smectite, 8 \% illite and 20 \% corundum.}
\item{Mix2}{Contains: 4 \% quartz, 8 \% K-feldspar, 36 \% plagioclase, 20 \% kaolinite,
12 \% illite and 20 \% corundum.}
\item{Mix3}{Contains: 8 \% quartz, 12 \% K-feldspar, 36 \% kaolinite, 4 \% dioctahedral
smectite, 20 \% illite and 20 \% corundum.}
\item{Mix4}{Contains: 12 \% quartz, 20 \% K-feldspar, 4 \% plagioclase, 8 \% dioctahedral
smectite, 36 \% illite and 20 \% corundum.}
\item{Mix5}{Contains: 20 \% quartz, 36 \% K-feldspar, 8 \% plagioclase, 4 \% kaolinite,
12 \% dioctahedral smectite and 20 \% corundum.}
\item{Mix6}{Contains: 36 \% quartz, 12 \% plagioclase, 8 \% kaolinite, 20 \% dioctahedral
smectite, 4 \% illite and 20 \% corundum.}
\item{Mix7}{Contains: 8 \% K-feldspar, 40 \% plagioclase, 4 \% kaolinite, 12 \% dioctahedral
smectite, 16 \% illite and 20 \% corundum.}
\item{Mix8}{Contains: 8 \% quartz, 4 \% K-feldspar, 4 \% plagioclase, 24 \% dioctahedral
smectite, 40 \% illite and 20 \% corundum.}
}}
\usage{
rockjock_mixtures
}
\description{
A list containing 8 XRPD measurements (Cu K-alpha radiation) of synthetic mixtures
that can be used to assess accuracy of quantitative analysis from the \code{fps()}
and \code{afps()} functions. The mixtures contain various amounts of quartz (QUARTZ
standard in of the \code{rockjock} library), K-feldspar (ORDERED_MICROCLINE),
plagioclase (LABRADORITE), kaolinite (KAOLINITE_DRY_BRANCH), dioctahedral smectite
(MONTMORILLIONITE_WYO), illite (ILLITE_1M_RM30) and corundum (CORUNDUM).
}
\references{
\url{https://pubs.er.usgs.gov/publication/ofr200378}
}
\author{
Dennis Eberl
}
\keyword{datasets}
