% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_zones_three_digit.R
\name{fetch_zones}
\alias{fetch_zones}
\title{Fetch zones for a 3-digit origin zip or an origin-destination pair}
\usage{
fetch_zones(origin_zip = NULL, destination_zip = NULL,
  exact_destination = FALSE, as_range = FALSE, show_details = FALSE,
  n_tries = 3, verbose = FALSE)
}
\arguments{
\item{origin_zip}{A single origin zip as character. If > 3 digits and contains leading zeros, make sure to supply as character.}

\item{destination_zip}{Optional destination zip. If not included, returns all possible destinations for the origin provided. If > 3 digits and contains leading zeros, make sure to supply as character.}

\item{exact_destination}{If \code{destination_zip} is supplied, should the result be filtered to the full destination zip, or its first 3 digits?}

\item{as_range}{Do you want zones corresponding to a range of destination zips or a full listing of them?}

\item{show_details}{Should columns with more details be retained?}

\item{n_tries}{How many times to try getting an origin if we're unsuccessful the first time?}

\item{verbose}{Message what's going on?}
}
\value{
A tibble with origin zip and destination zips (in ranges or unspooled) and the USPS zones the origin-destination pair corresponds to.
}
\description{
For a given 3-digit origin zip code, grab all destination zips and their corresponding zones.
}
\details{
Displays the result of a query to the ["Get Zone Chart"](https://postcalc.usps.com/DomesticZoneChart/) tab. If you just want to supply two 5-digit zips and get a single zone back, use \code{fetch_zones_five_digit}.
}
\examples{
\dontrun{

a_zip <- fetch_zones("123")
nrow(a_zip)

fetch_zones("123", "456", show_details = TRUE)

(double_oh_seven <- fetch_zones("007", as_range = TRUE))
}

}
