% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_postgis_query.R
\name{get_postgis_query}
\alias{get_postgis_query}
\title{Send SELECT query and parse geometry, hstore columns}
\usage{
get_postgis_query(conn, statement, geom_name = NA_character_,
  hstore_name = NA_character_)
}
\arguments{
\item{conn}{A \code{\link[RPostgreSQL]{PostgreSQLConnection-class}} object,
such as the output of \code{\link[DBI]{dbConnect}}.}

\item{statement}{Character string for a SQL SELECT query.}

\item{geom_name}{Name of the geometry column (\code{NA} if none).}

\item{hstore_name}{Name of the hstore column (\code{NA} if none).}
}
\value{
Either a data frame (if \code{geom_name = NA}) or a
  Spatial[Points/Lines/Polygons]DataFrame containing the query result. If a
  hstore column is present, it appears as a list-column in the data frame,
  i.e. each cell is a named list of key-value pairs.
}
\description{
This function is an extension of \code{\link[DBI]{dbGetQuery}} that is useful
in cases where selected columns include a PostgreSQL hstore, which is parsed
as a list-column, and/or a PostGIS geometry, in which case the output is a
spatial data frame (from the \code{\link[sp]{sp}} package).
}
\details{
Conversion to spatial data frame objects will fail if there are \code{NULL}
values in the geometry column, so these should be filtered out in the provided
query statement.
}
\examples{
\dontrun{
library(RPostgreSQL)
con <- dbConnect(PostgreSQL(), dbname = "my_db")

# If geom column holds points, returns a SpatialPointsDataFrame
cities <- get_postgis_query(con, "SELECT name, geom, datalist FROM city",
                            geom_name = "geom", hstore_name = "datalist")

# Get the populations (part of datalist hstore) as a vector
pop <- cities@data$datalist \%->\% "population"
}

}
\references{
The code for importing geom fields is based on a blog post by
  Lee Hachadoorian: \href{http://www.r-bloggers.com/load-postgis-geometries-in-r-without-rgdal/}{Load PostGIS geometries in R without rgdal}.
}
\seealso{
The \code{\link{\%->\%}} operator for working with hstore columns;
  \code{\link{postgis_insert}} and \code{\link{postgis_update}} for writing
  to a PostgreSQL connection.
}

