% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsIncomparableWith.R
\name{IsIncomparableWith}
\alias{IsIncomparableWith}
\title{Checking incomparability between two elements of a poset.}
\usage{
IsIncomparableWith(poset, element1, element2)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{element1}{A character string (the name of a poset element).}

\item{element2}{A character string (the name of a poset element).}
}
\value{
A boolean value.
}
\description{
Checks whether two elements \eqn{a} and \eqn{b} of \eqn{V} are incomparable, in the input poset \eqn{(V,\leq)}.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

chk <- IsIncomparableWith(pos, "a", "d")

}
