% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/port4me.R
\name{port4me}
\alias{port4me}
\title{Gets a Personalized TCP Port that can be Opened by the User}
\usage{
port4me(
  tool = NULL,
  user = NULL,
  prepend = NULL,
  include = NULL,
  exclude = NULL,
  skip = NULL,
  list = NULL,
  test = NULL,
  max_tries = 65535L,
  must_work = TRUE
)
}
\arguments{
\item{tool}{(optional) The name of the software tool for which a port
should be generated.}

\item{user}{(optional) The name of the user.
Defaults to \code{Sys.info()[["user"]]}.}

\item{prepend}{(optional) An integer vector of ports to always consider.}

\item{include}{(optional) An integer vector of possible ports to return.
Defaults to \code{1024:65535}.}

\item{exclude}{(optional) An integer vector of ports to exclude.}

\item{skip}{(optional) Number of non-excluded ports to skip.
Defaults to \code{0L}.}

\item{list}{(optional) Number of ports to list.}

\item{test}{(optional) A port to check whether it can be opened or not.}

\item{max_tries}{Maximum number of ports checked, before giving up.
Defaults to \code{65535L}.}

\item{must_work}{If TRUE, then an error is produced if no port could
be found.  If FALSE, then \code{-1} is returned.}
}
\value{
A port, or a vector of ports.
If \code{test} is given, then TRUE is if the port can be opened, otherwise FALSE.
}
\description{
Gets a Personalized TCP Port that can be Opened by the User
}
\examples{
port <- port4me()
print(port)

port <- port4me(tool = "rstudio")
print(port)

port <- port4me("rstudio") ## short for the above
print(port)

ports <- port4me(tool = "rstudio", list = 5L)
print(ports)

avail <- port4me(test = 4321)
print(avail)


}
\seealso{
The default values of the arguments can be controlled via environment
variables.  See \link{port4me.settings} for details.
}
