% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-functions.R
\name{check_n}
\alias{check_n}
\title{Check Whole Number}
\usage{
check_n(n, nm_n, min, max, divisible_by)
}
\arguments{
\item{n}{A whole number}

\item{nm_n}{Name for 'n' to be used in error messages}

\item{min}{Minimum value 'n' can take. Can be NULL.}

\item{max}{Maximum values 'n' can take. Can be NULL.}

\item{divisible_by}{'n' must be divisible by this. Can be NULL.}
}
\value{
If all tests pass, \code{check_n()} returns \code{TRUE} invisibly.
Otherwise it throws an error.
}
\description{
Check that \code{n} is  finite, non-NA scalar that
is an integer or integerish (ie is equal to \code{round(n)}),
and optionally within a specified range
and divisible by a specified number.
}
\examples{
check_n(10, nm_n = "count", min = 0, max = NULL, divisible_by = 1)
check_n(10, nm_n = "count", min = NULL, max = NULL, divisible_by = NULL)
check_n(10, nm_n = "n", min = 5, max = 10, divisible_by = 2)
}
