% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varyingPDXnPDXrBiolRR.R
\name{varyingPDXnPDXrBiolRR}
\alias{varyingPDXnPDXrBiolRR}
\title{Function to run simulations to mimic population PDX studies for variety of experimental and biological scenarios}
\usage{
varyingPDXnPDXrBiolRR(PDXn_range, PDXr_range, Biol_RR_range, C_Acc, iterations)
}
\arguments{
\item{PDXn_range}{a vector of PDXn values to study}

\item{PDXr_range}{a vector of PDXr values to study}

\item{Biol_RR_range}{a vector of values between 0 and 100 to indicate the Biol_RR to study}

\item{C_Acc}{the classification accuracy (numeric value between 0 and 1)}

\item{iterations}{iterations}
}
\value{
a dataframe where each row represents the results from a simulation mimicking an individual experiment for a particular design with meta data returned to describe the experimental design
}
\description{
This is an internal function. Please use cautiously if calling directly.
Simulations are used to mimic population PDX studies by inputing a variety of experimental factors (PDXn and PDXr) and biological factors (Biol_RR and C_Acc).
Example usage: \code{varyingPDXnPDXrBiolRR(PDXn_range=c(8,10,12), PDXr_range=c(1,3,5), Biol_RR_range=c(30,40,50), C_Acc=0.95, iterations=500)}
}
\author{
Maria Luisa Guerriero, \email{maria.guerriero@astrazeneca.com}

Natasha A. Karp, \email{natasha.karp@astrazeneca.com}
}
