% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callsInSingleExperiment.R
\name{callsInSingleExperiment}
\alias{callsInSingleExperiment}
\title{Simulation of a single population PDX experiment}
\usage{
callsInSingleExperiment(PDXn, PDXr, C_Acc, Biol_RR)
}
\arguments{
\item{PDXn}{number of PDX models studied}

\item{PDXr}{number of mice measured per PDX model}

\item{C_Acc}{classification accuracy}

\item{Biol_RR}{underlying biological response rate for this treatment}
}
\value{
dataframe with three columns:

- PDXModel is a string that indicates the model id

- PDXclassification is a numeric value that indicates the true biological classification of that PDX - 0 equal non-responder and 1 equal responder

- StudyResult is a numeric value that indicates the classification of the PDX model after sampling - 0 equal non-responder and 1 equal responder
}
\description{
This is an internal function. Please use cautiously if calling directly.
Samples some animals and classify as responders or non-responders based on number of models studied (PDXn), number of mice measured per model (PDXr), the classification accuracy (C_Acc) and the underlying biological response rate (Biol_RR).
Example usage: \code{callsInSingleExperiment(PDXn=8, PDXr=3, C_Acc=0.95, Biol_RR=30)}
}
\author{
Maria Luisa Guerriero, \email{maria.guerriero@astrazeneca.com}

Natasha A. Karp, \email{natasha.karp@astrazeneca.com}
}
