% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_data.R
\name{incomp}
\alias{incomp}
\title{Check for samples that are incomparable due to missing data}
\usage{
incomp(gid)
}
\arguments{
\item{gid}{a genind or genclone object}
}
\value{
a square matrix with samples that are incomparable
}
\description{
If two samples share no loci typed in common, they are incomparable and will
produce missing data in a distance matrix, which could lead to problems with
further analyses. This function finds these samples and returns a matrix of
how many other samples these are incomparable with.
}
\examples{

data(nancycats)
# These two populations have no samples that are incomparable
incomp(nancycats[pop = c(1, 17)])

# If you reduce the number of loci, we find that there are 
# incomparable samples.
incomp(nancycats[pop = c(1, 17), loc = c(1, 4)])
}
