% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isIrreducible.R
\name{isIrreducible}
\alias{isIrreducible}
\title{Determine reducibility of a matrix}
\usage{
isIrreducible(A)
}
\arguments{
\item{A}{a square, non-negative numeric matrix of any dimension.}
}
\value{
\code{TRUE} (for an irreducible matrix) or \code{FALSE} (for a reducible 
matrix).
}
\description{
Determine whether a matrix is irreducible or reducible
}
\details{
\code{isIrreducible} works on the premise that a matrix \strong{A} 
is irreducible if and only if (\strong{I}+\strong{A})^(s-1) is positive, 
where \strong{I} is the identity matrix of the same dimension as \strong{A} 
and s is the dimension of \strong{A} (Caswell 2001).
}
\examples{
  # Create a 3x3 irreducible PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Diagnose reducibility
  isIrreducible(A)

  # Create a 3x3 reducible PPM
  B<-A; B[3,2] <- 0; B

  # Diagnose reducibility
  isIrreducible(B)

}
\references{
\itemize{
 \item Caswell (2001) matrix Population Models, 2nd. ed. Sinauer.
}
}
\seealso{
Other PerronFrobeniusDiagnostics: \code{\link{isErgodic}},
  \code{\link{isPrimitive}}
}
\concept{
reducibility reducible irreducible Perron Frobenius
}
