% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joins.R
\name{mutate_joins}
\alias{mutate_joins}
\alias{inner_join}
\alias{left_join}
\alias{right_join}
\alias{full_join}
\title{Mutating Joins}
\usage{
inner_join(x, y, by = NULL, suffix = c(".x", ".y"))

left_join(x, y, by = NULL, suffix = c(".x", ".y"))

right_join(x, y, by = NULL, suffix = c(".x", ".y"))

full_join(x, y, by = NULL, suffix = c(".x", ".y"))
}
\arguments{
\item{x, y}{The \code{data.frame}s to join.}

\item{by}{A character vector of variables to join by. If \code{NULL}, the default,
\verb{*_join()} will do a natural join, using all variables with common names
across the two tables. A message lists the variables so that you can check
they're right (to suppress the message, simply explicitly list the variables
that you want to join).

To join by different variables on x and y use a named vector. For example,
\code{by = c("a" = "b")} will match \code{x.a} to \code{y.b}.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and \code{y},
these suffixes will be added to the output to disambiguate them. Should be a
character vector of length 2.}
}
\description{
The mutating joins add columns from \code{y} to \code{x}, matching rows based on the keys:
\itemize{
\item \code{inner_join()}: includes all rows in \code{x} and \code{y}.
\item \code{left_join()}: includes all rows in \code{x}.
\item \code{right_join()}: includes all rows in \code{y}.
\item \code{full_join()}: includes all rows in \code{x} or \code{y}.
}

If a row in \code{x} matches multiple rows in \code{y}, all the rows in \code{y} will be returned once for each matching row in \code{x}.
}
