% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context}
\alias{context}
\alias{n}
\alias{cur_data}
\alias{cur_group}
\alias{cur_group_id}
\alias{cur_group_rows}
\title{Context dependent expressions}
\usage{
n()

cur_data()

cur_group()

cur_group_id()

cur_group_rows()
}
\description{
These functions return information about the "current" group or "current" variable, so only work inside specific
contexts like \code{\link[=summarise]{summarise()}} and \code{\link[=mutate]{mutate()}}.

\itemize{
\item \code{n()} gives the number of observations in the current group.
}

\itemize{
\item \code{cur_data()} gives the current data for the current group (excluding grouping variables).
}

\itemize{
\item \code{cur_group()} gives the group keys, a single row \code{data.frame} containing a column for each grouping variable and
its value.
}

\itemize{
\item \code{cur_group_id()} gives a unique numeric identifier for the current group.
}

\itemize{
\item \code{cur_group_rows()} gives the rows the groups appear in the data.
}
}
\section{\code{data.table}}{

If you're familiar with \code{data.table}:
\itemize{
\item \code{cur_data()} <-> \code{.SD}
\item \code{cur_group_id()} <-> \code{.GRP}
\item \code{cur_group()} <-> \code{.BY}
\item \code{cur_group_rows()} <-> \code{.I}
}
}

\examples{
df <- data.frame(
  g = sample(rep(letters[1:3], 1:3)),
  x = runif(6),
  y = runif(6),
  stringsAsFactors = FALSE
)
gf <- df \%>\% group_by(g)

gf \%>\% summarise(n = n())

gf \%>\% mutate(id = cur_group_id())
gf \%>\% summarise(row = cur_group_rows())
gf \%>\% summarise(data = list(cur_group()))
gf \%>\% summarise(data = list(cur_data()))

}
\seealso{
See \code{\link[=group_data]{group_data()}} for equivalent functions that return values for all groups.
}
