% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise}
\alias{summarise}
\title{Reduce multiple values down to a single value}
\usage{
summarise(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Name-value pairs of summary functions. The name will be the name of the variable in the result. The value
should be an expression that returns a single value, e.g. \code{min(x)}.}
}
\description{
Create one or more scalar variables summarising the variables of an existing \code{data.frame}. Grouped \code{data.frame}s will
result in one row in the output for each group.
}
\examples{
summarise(mtcars, mean(mpg))
summarise(mtcars, meanMpg = mean(mpg), sumMpg = sum(mpg))
mtcars \%>\% summarise(mean(mpg))

}
