% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R, R/select.R
\name{rename}
\alias{rename}
\alias{select}
\title{Select/rename variables by name}
\usage{
rename(.data, ...)

select(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{The name(s) of the column(s) to select.}
}
\value{
A \code{data.frame}.
}
\description{
Choose or rename variables from a \code{data.frame}. \code{select()} keeps only the
variables you mention; \code{rename()} keeps all the variables.
}
\examples{
rename(mtcars, MilesPerGallon = mpg)
rename(mtcars, Cylinders = cyl, Gears = gear)
mtcars \%>\% rename(MilesPerGallon = mpg)

select(mtcars, mpg, cyl)
select(mtcars, MilesPerGallon = mpg, Cylinders = cyl)
mtcars \%>\% select(mpg)
mtcars \%>\% select(mpg, cyl)

}
