% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dfa2.R
\name{plot_dfa2}
\alias{plot_dfa2}
\title{Plot Log-OR vs. X for Gamma Discriminant Function Approach}
\usage{
plot_dfa2(estimates, varcov = NULL, xrange, xname = "X", cvals = NULL,
  set_labels = NULL, set_panels = TRUE)
}
\arguments{
\item{estimates}{Numeric vector of point estimates for
\code{(gamma_0, gamma_1, gamma_c^T, b1, b0)}.}

\item{varcov}{Numeric matrix with variance-covariance matrix for
\code{estimates}. If \code{NULL}, 95\% confidence bands are omitted.}

\item{xrange}{Numeric vector specifying range of \code{X} values to plot.}

\item{xname}{Character vector specifying name of \code{X} variable, for
plot title and x-axis label.}

\item{cvals}{Numeric vector or list of numeric vectors specifying covariate
values to use in log-odds ratio calculations.}

\item{set_labels}{Character vector of labels for the sets of covariate
values. Only used if \code{cvals} is a list.}

\item{set_panels}{Logical value for whether to use separate panels for each
set of covariate values, as opposed to using different colors on a single
plot.}
}
\value{
Plot of log-OR vs. \code{X} generated by
\code{\link[ggplot2]{ggplot}}.
}
\description{
When \code{\link{p_dfa_xerrors2}} is fit with \code{constant_or = FALSE}, the
log-odds ratio for \code{X} depends on the value of \code{X} (and covariates,
if there are any). This function plots the log-odds ratio vs. \code{X} for
one or several sets of covariate values.
}
\examples{
# Fit Gamma discriminant function model for poolwise Xtilde vs. (Y, C),
# without assuming a constant log-OR. Ignoring processing errors for simplicity.
data(pdat2)
data(pdat2_c)
fit <- p_dfa_xerrors2(g = pdat2$g, y = pdat2$y, xtilde = pdat2$xtilde,
                      c = pdat2_c, errors = "neither", constant_or = FALSE)

# Plot estimated log-OR vs. X at mean value for C
p <- plot_dfa2(estimates = fit$estimates, varcov = fit$theta.var,
               xrange = range(pdat2$xtilde / pdat2$g),
               cvals = mean(unlist(pdat2_c)))
p


}
