% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.params2symbolicfstats.R
\name{graph.params2symbolic.fstats}
\alias{graph.params2symbolic.fstats}
\title{Provide a symbolic representation of all the F-statistics and the model system of equations}
\usage{
graph.params2symbolic.fstats(x, outfile = NULL)
}
\arguments{
\item{x}{An object of class graph.params containing graph information and relevant Fstats estimates (see the function generate.graph.params)}

\item{outfile}{The file where to print the equations (default=NULL, equations are not printed in a file)}
}
\value{
A list with the following elements:
\enumerate{
\item "model.matrix": A symbolic representation of the matrix M relating the basis F-statistics and graph edge length as F=M*b where F is the vector of the basis Fstats (row names of model.matrix M) and b is the vector of graph edges (column names of model.matrix M).
\item "omega": A symbolic representation of the scaled covariance matrix of allele frequency with edge names and admixture parameter names as specified in the edges.names and adm.params.names slot of the input graph.params object x
\item "F2.equations": A symbolic representation of the nleaves(nleaves-1)/2 different F2 as a function of graph parameters
\item "F3.equations": A symbolic representation  of the nleaves(nleaves-1)(nleaves-2)/2 different F3 as a function of graph parameters 
\item "F4.equations": A symbolic representation of the npops(npops-1)(npops-2)(npops-3)/8 different F4 as a function of graph parameters
}
}
\description{
Provide a symbolic representation of all the F-statistics and the model system of equations
}
\examples{
graph=rbind(c("P1","P7",""),c("P2","s1",""),c("P3","s2",""),c("P6","S",""),
            c("S","s1","a"),c("S","s2","(1-a)"),c("s2","P8",""),c("s1","P7",""),
            c("P4","P9",""),c("P5","P9",""),c("P7","P8",""),
            c("P8","R",""),c("P9","R","")) 
graph.params=generate.graph.params(graph)
graph.equations=graph.params2symbolic.fstats(graph.params) 
}
\seealso{
To generate a graph.params object, see \code{\link{generate.graph.params}}.
}
