% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.countdata.R
\docType{class}
\name{countdata-class}
\alias{countdata-class}
\alias{countdata}
\title{S4 class to represent a Count data set.}
\description{
S4 class to represent a Count data set.
}
\section{Slots}{

\describe{
\item{\code{npops}}{The number of populations}

\item{\code{nsnp}}{The number of SNPs}

\item{\code{refallele.count}}{A matrix (nsnp rows and npops columns) with the allele counts for the reference allele}

\item{\code{total.count}}{A matrix (nsnp rows and npops columns) with the total number of counts (i.e., twice the number of genotyped individual for diploid species and autosomal markers)}

\item{\code{snp.info}}{A data frame (nsnp rows and 4 columns) detailing for each SNP, the chromosome (or scaffold), the position, Reference allele name and Alternate allele name (if available)}

\item{\code{popnames}}{A vector of length npops with the corresponding population names}
}}

\seealso{
To generate countdata object, see \code{\link{genobaypass2countdata}} and \code{\link{genotreemix2countdata}}
}
