% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooldata.subset.R
\name{pooldata.subset}
\alias{pooldata.subset}
\title{Create a subset of the pooldata object that contains Pool-Seq data}
\usage{
pooldata.subset(pooldata, pool.index = c(1, 2), min.cov.per.pool = -1,
  max.cov.per.pool = 1e+06, min.maf = -1)
}
\arguments{
\item{pooldata}{A pooldata object containing Pool-Seq information}

\item{pool.index}{Indexes of the pools (at least two), that should be selected to create the new pooldata object}

\item{min.cov.per.pool}{Minimal allowed read count (per pool). If at least one pool is not covered by at least min.cov.perpool reads, the position is discarded}

\item{max.cov.per.pool}{Maximal allowed read count (per pool). If at least one pool is covered by more than min.cov.perpool reads, the position is discarded}

\item{min.maf}{Minimal allowed Minor Allele Frequency (computed from the ratio overal read counts for the reference allele over the read coverage)}
}
\value{
A pooldata object with 7 elements:
\enumerate{
\item "refallele.readcount": a matrix with nsnp rows and npools columns containing read counts for the reference allele (chosen arbitrarily) in each pool
\item "readcoverage": a matrix with nsnp rows and npools columns containing read coverage in each pool
\item "snp.info": a matrix with nsnp rows and four columns containing respectively the contig (or chromosome) name (1st column) and position (2nd column) of the SNP; the allele in the reference assembly (3rd column); the allele taken as reference in the refallele matrix.readcount matrix (4th column); and the alternative allele (5th column)
\item "poolsizes": a vector of length npools containing the haploid pool sizes
\item "poolnames": a vector of length npools containing the names of the pools
\item "nsnp": a scalar corresponding to the number of SNPs
\item "npools": a scalar corresponding to the number of pools
}
}
\description{
Create a subset of the pooldata object that contains Pool-Seq data
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 pooldata.subset=pooldata.subset(pooldata,pool.index=c(1,2))
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}}
}
