% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSEM.R
\name{uSEM}
\alias{uSEM}
\title{Fit a multivariate time series with uSEM (unified Structural Equation Model).}
\usage{
uSEM(var.number,
     data,
     lag.order = 1,
     verbose = FALSE,
     trim = FALSE)
}
\arguments{
\item{var.number}{number of variables in the time series}

\item{data}{time series data, must be in long format}

\item{lag.order}{lag order of the model to be fit, default value is 1. Note: Higher order (greater than 1) might not run.}

\item{verbose}{print intermediate model fit (iterations), default value is FALSE}

\item{trim}{to trim the insignificant betas (just one step, not iterative), default value is FALSE}
}
\value{
model fit object generated by lavaan
}
\description{
Fit a multivariate time series with uSEM (unified Structural Equation Model).
}
\details{
The purpose of uSEM is to quantify the temporal relations (both contemporaneous and lag-1) between
variables. Model specification and estimation can be found in the references.
}
\examples{
\dontshow{
model.fit <- uSEM(var.number = 3,
                 data = simts_3node,
                 lag.order = 1,
                 verbose = FALSE,
                 trim = FALSE)
model.fit
}
\donttest{
model.fit <- uSEM(var.number = 3,
                 data = simts_3node,
                 lag.order = 1,
                 verbose = FALSE,
                 trim = FALSE)
model.fit
}

}
\references{
Kim, J., Zhu, W., Chang, L., Bentler, P. M., & Ernst, T. (2007). Unified Structural Equation Modeling Approach for the Analysis of Multisubject, Multivariate Functional MRI Data. Human Brain Mapping, 93, 85–93. doi:10.1002/hbm.20259

Gates, K. M., & Molenaar, P. C. M. (2012). Group search algorithm recovers effective connectivity maps for individuals in homogeneous and heterogeneous samples. NeuroImage 63(1), 310-319. doi: 10.1016/j.neuroimage.2012.06.026

Gates, K. M., Molenaar, P. C. M., Hillary, F. G., Ram, N., & Rovine, M. J. (2010). Automatic search for fMRI connectivity mapping: An alternative to Granger causality testing using formal equivalences among SEM path modeling, VAR, and unified SEM. NeuroImage, 50(3), 1118–1125.  doi: 10.1016/j.neuroimage.2009.12.117
}
