% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uSEM.R
\name{parse_beta}
\alias{parse_beta}
\title{Parse the beta from model fit object}
\usage{
parse_beta(var.number, model.fit, lag.order, matrix = F)
}
\arguments{
\item{var.number}{number of variables in the time series}

\item{model.fit}{model fit object generated by lavaan}

\item{lag.order}{lag order of the model to be fit}

\item{matrix}{output beta in matrix format or estimates format, default value is FALSE (as estimates)}
}
\value{
beta
}
\description{
Parse the beta from model fit object
}
\examples{
\dontshow{
data(usemmodelfit)
beta.matrix <- parse_beta(var.number = 3,
                         model.fit = usemmodelfit,
                         lag.order = 1,
                         matrix = TRUE)
beta.matrix
}
\donttest{
data(usemmodelfit)
beta.matrix <- parse_beta(var.number = 3,
                         model.fit = usemmodelfit,
                         lag.order = 1,
                         matrix = TRUE)
beta.matrix
}

}
