% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{fast_permute}
\alias{fast_permute}
\title{Extension of the \code{\link{QTLscan}} function, offering an optimised permutation test when the experimental setting (i.e. phenotype structure) is simple}
\usage{
fast_permute(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  ploidy,
  ploidy2 = NULL,
  N_perm = 1000,
  alpha = 0.05,
  ncores = 1,
  verbose = TRUE,
  log = NULL
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the offspring identifiers (F1 names)}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model}

\item{ploidy}{Integer. The ploidy of parent 1}

\item{ploidy2}{The ploidy of parent 2, by default \code{NULL} i.e. assumed (unless specified) to be equal to the ploidy of parent 1.}

\item{N_perm}{The number of permutations to run, by default this is 1000.}

\item{alpha}{The P-value to be used in the selection of a threshold, by default 0.05 (i.e. the 0.95 quantile).}

\item{ncores}{Number of cores to use, by default 1 only. Works both for Windows and UNIX (using \code{doParallel}).
Use \code{parallel::detectCores()} to find out how many cores you have available.}

\item{verbose}{Logical, by default \code{TRUE}. Should messages be printed during running?}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
A nested list; each list element (per linkage group) contains the following items:
\itemize{
\item{QTL.res : }{Single matrix of QTL results with columns chromosome, position, LOD}
\item{Perm.res : }{List of the results of the permutation test, with (at least) list items
"quantile","threshold" and "scores". Quantile refers to which quantile of scores was used to determine the threshold.
Note that scores are each of the maximal LOD scores across the entire genome scan per permutation, thus returning a
genome-wide threshold rather than a chromosome-specific threshold. If the latter is preferred, restricting the
\code{IBD_list} to a single chromosome and re-running the permutation test will provide the desired threshold.}
\item{Map : }{Original map of genetic marker positions upon which the IBDs were based, most often used
for adding rug of marker positions to QTL plots.}
}
}
\description{
Function to run optimised QTL permutation test using IBD probabilities
}
\examples{
data("IBD_4x","Phenotypes_4x")
qtl_LODs.4x <- fast_permute(IBD_list = IBD_4x,
                       Phenotype.df = Phenotypes_4x,
                       genotype.ID = "geno",
                       trait.ID = "pheno",
                       ploidy = 4)
}
