% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{linkage.gp}
\alias{linkage.gp}
\title{Calculate recombination frequency, LOD and phase using genotype probabilities}
\usage{
linkage.gp(
  probgeno_df,
  chk,
  pardose = NULL,
  markertype1 = c(1, 0),
  markertype2 = NULL,
  target_parent = match.arg(c("P1", "P2")),
  G2_test = FALSE,
  LOD_threshold = 0,
  prefPars = c(0, 0),
  combinations_per_iter = NULL,
  iter_RAM = 500,
  ncores = 2,
  verbose = TRUE,
  log = NULL
)
}
\arguments{
\item{probgeno_df}{A data frame as read from the scores file produced by function \code{saveMarkerModels} of R package \code{fitPoly}, or alternatively, a data frame containing the following columns:
\itemize{
\item{SampleName}{
Name of the sample (individual)
}
\item{MarkerName}{
Name of the marker
}
\item{P0}{
Probabilities of dosage score '0'
}
\item{P1...}{
Probabilities of dosage score '1' etc. (up to max offspring dosage, e.g. P4 for tetraploid population)
}
\item{maxP}{
Maximum genotype probability identified for a particular individual and marker combination
}
\item{maxgeno}{
Most probable dosage for a particular individual and marker combination
}
\item{geno}{
Most probable dosage for a particular individual and marker combination, if \code{maxP} exceeds a user-defined threshold (e.g. 0.9), otherwise \code{NA}}
}}

\item{chk}{Output list as returned by function \code{\link{checkF1}}}

\item{pardose}{Option to include the most likely (discrete) parental dosage scores, used mainly for internal calls of this function. By default \code{NULL}}

\item{markertype1}{A vector of length 2 specifying the first markertype to compare. The first element specifies the dosage in \code{target_parent} (and the second in the other parent).}

\item{markertype2}{A vector of length 2 specifying the first markertype to compare. This argument is optional. If not specified, the function will calculate
linkage within the markertype as specified by \code{markertype1}.
The first element specifies the dosage in \code{target_parent} (and the second in the other parent).}

\item{target_parent}{Which parent is being targeted (only acceptable options are "P1" or "P2"), ie. which parent is of specific interest? 
If this is the maternal parent, please specify as "P1". If the paternal parent, please use "P2". The actual identifiers of the two parents are
entered using the arguments \code{parent1_replicates} and \code{parent2_replicates}.}

\item{G2_test}{Apply a G2 test (LOD of independence) in addition to the LOD of linkage.}

\item{LOD_threshold}{Minimum LOD score of linkages to report. Recommended to use for large number (> millions) of marker comparisons in order to reduce memory usage.}

\item{prefPars}{The estimates for preferential pairing parameters for parent 1 and 2, in range 0 <= p < 2/3. By default this is c(0,0) (so, no preferential pairing).
See the function \code{\link{test_prefpairing}} and the vignette for more details.}

\item{combinations_per_iter}{Optional integer. Number of marker combinations per iteration.}

\item{iter_RAM}{A (very) conservative estimate of working memory in megabytes used per core. It only takes the size frequency matrices into account. Actual usage is more, especially with large number of linkages that are reported. Reduce memory usage by using a higher LOD_threshold.}

\item{ncores}{Number of cores to use. Works both for Windows and UNIX (using \code{doParallel}). Use \code{parallel::detectCores()} to find out how many cores you have available.}

\item{verbose}{Should messages be sent to stdout?}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Returns a data.frame with columns:
\itemize{
\item{marker_a}{
  first marker of comparison. If markertype2 is specified, it has the type of markertype1.
}
\item{marker_b}{
  second marker of comparison. It has the type of markertype2 if specified.
}
\item{r}{
  (estimated) recombinations frequency
}
\item{LOD}{
  (estimated) LOD score
}
\item{phase}{
  phase between markers
}
}
}
\description{
\code{linkage.gp} is used to calculate recombination frequency, LOD and phase within one type of marker or between two types of markers.
}
\examples{
data("gp_df","chk1")
SN_SN_P1.gp <- linkage.gp(probgeno_df = gp_df,
                          chk = chk1,
                          markertype1 = c(1,0),
                          target_parent = "P1")
}
