% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{write_pwd_list}
\alias{write_pwd_list}
\title{Write pwd files from a nested list}
\usage{
write_pwd_list(linkages_list, target_parent, binned = FALSE,
  dir = getwd(), log = NULL)
}
\arguments{
\item{linkages_list}{A nested \code{list} with linkage group on the first level and homologue on the second.}

\item{target_parent}{A  character string specifying the name of the target parent.}

\item{binned}{Logical. Are the markers binned? This information is used in the pwd header.}

\item{dir}{A character string specifying the directory in which the files are written. Defaults to working directory.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\description{
A wrapper for \code{\link{write.pwd}}, which allows to write multiple pwd files with a directory structure according to the nested linkage list.
}
\examples{
data("all_linkages_list_P1_split")
write_pwd_list(all_linkages_list_P1_split, target_parent="P1", binned=FALSE)
}
