% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.R
\name{noise}
\alias{noise}
\alias{noise,DocumentTermMatrix-method}
\alias{noise,TermDocumentMatrix-method}
\alias{noise,character-method}
\alias{noise,textstat-method}
\title{detect noise}
\usage{
noise(.Object, ...)

\S4method{noise}{DocumentTermMatrix}(
  .Object,
  minTotal = 2,
  minTfIdfMean = 0.005,
  sparse = 0.995,
  stopwordsLanguage = "german",
  minNchar = 2,
  specialChars = getOption("polmineR.specialChars"),
  numbers = "^[0-9\\\\.,]+$",
  verbose = TRUE
)

\S4method{noise}{TermDocumentMatrix}(.Object, ...)

\S4method{noise}{character}(
  .Object,
  stopwordsLanguage = "german",
  minNchar = 2,
  specialChars = getOption("polmineR.specialChars"),
  numbers = "^[0-9\\\\.,]+$",
  verbose = TRUE
)

\S4method{noise}{textstat}(.Object, p_attribute, ...)
}
\arguments{
\item{.Object}{an .Object of class \code{"DocumentTermMatrix"}}

\item{...}{further parameters}

\item{minTotal}{minimum colsum (for DocumentTermMatrix) to qualify a term as non-noise}

\item{minTfIdfMean}{minimum mean value for tf-idf to qualify a term as non-noise}

\item{sparse}{will be passed into \code{"removeSparseTerms"} from \code{"tm"}-package}

\item{stopwordsLanguage}{e.g. "german", to get stopwords defined in the tm package}

\item{minNchar}{min char length ti qualify a term as non-noise}

\item{specialChars}{special characters to drop}

\item{numbers}{regex, to drop numbers}

\item{verbose}{logical}

\item{p_attribute}{relevant if applied to a textstat object}
}
\value{
a list
}
\description{
detect noise
}
