% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{registry_reset}
\alias{registry_reset}
\alias{registry}
\title{Reset Registry Directory.}
\usage{
registry_reset(registryDir = registry(), verbose = TRUE)

registry()
}
\arguments{
\item{registryDir}{path to the registry directory to be used}

\item{verbose}{logical, whether to be verbose}
}
\value{
the registry directory used before resetting CORPUS_REGISTRY
}
\description{
A utility function to reset the environment variable CORPUS_REGISTRY. That may
be necessary if you want use a CWB corpus that is not stored in the usual
place. In particular, resetting the environment variable is required if you
want to use a corpus delivered in a R package,

The \code{polmineR} package uses a subdirectory of the per-session temporary directory
as a (temporary) registry. The \code{registry} function will return the path 
to this directory.
}
\details{
Resetting the CORPUS_REGISTRY environment variable is also necessary for the
interface to CWB corpora.

To get the path to a package that contains a CWB corpus, use
\code{system.file} (see examples).
}
\examples{
x <- system.file(package = "polmineR", "extdata", "cwb", "registry")
registry_reset(registryDir = x)
registry()
}
\seealso{
To conveniently reset registry, see \code{\link{use}}.
}
