% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic.R
\docType{methods}
\name{kwic}
\alias{kwic}
\alias{kwic,context-method}
\alias{kwic,partition-method}
\alias{kwic,character-method}
\title{KWIC/concordance output.}
\usage{
kwic(.Object, ...)

\S4method{kwic}{context}(.Object, meta = getOption("polmineR.meta"),
  cpos = TRUE, verbose = FALSE)

\S4method{kwic}{partition}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  meta = getOption("polmineR.meta"), p_attribute = "word",
  s_attribute = NULL, cpos = TRUE, stoplist = NULL, positivelist = NULL,
  regex = FALSE, verbose = TRUE, ...)

\S4method{kwic}{character}(.Object, query, cqp = is.cqp,
  left = as.integer(getOption("polmineR.left")),
  right = as.integer(getOption("polmineR.right")),
  meta = getOption("polmineR.meta"), p_attribute = "word",
  s_attribute = NULL, cpos = TRUE, stoplist = NULL, positivelist = NULL,
  regex = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{.Object}{a \code{partition} or \code{context} object}

\item{...}{further parameters to be passed}

\item{meta}{metainformation to display}

\item{cpos}{logical, if TRUE, the corpus positions ("cpos") if the hits will be handed over to the kwic-object that is returned}

\item{verbose}{logical, whether to be talkative}

\item{query}{a query, CQP-syntax can be used}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not (defaults to is.query
auxiliary function)}

\item{left}{to the left}

\item{right}{to the right}

\item{p_attribute}{p-attribute, defaults to 'word'}

\item{s_attribute}{if provided, the s-attribute will be used to check the boundaries of the text}

\item{stoplist}{terms or ids to prevent a concordance from occurring in results}

\item{positivelist}{terms or ids required for a concordance to occurr in results}

\item{regex}{logical, whether stoplist/positivelist is processed as regular expression}
}
\description{
Prepare and show concordances / keyword-in-context (kwic). The same result can be achieved by 
applying the kwic method on either a partition or a context object.
}
\details{
If a positivelist ist supplied, the tokens will be highlighted.
}
\examples{
use("polmineR")
bt <- partition("GERMAPARLMINI", def = list(date = ".*"), regex=TRUE)
kwic(bt, "Integration")
kwic(bt, "Integration", left = 20, right = 20, meta = c("date", "speaker", "party"))
kwic(
  bt, '"Integration" [] "(Menschen|Migrant.*|Personen)"',
  left = 20, right = 20,
  meta = c("date", "speaker", "party")
) 
}
\references{
Baker, Paul (2006): \emph{Using Corpora in Discourse Analysis}. London: continuum, pp. 71-93 (ch. 4).

Jockers, Matthew L. (2014): \emph{Text Analysis with R for Students of Literature}.
Cham et al: Springer, pp. 73-87 (chs. 8 & 9).
}
\seealso{
To read the whole text, see the \code{\link{read}}-method.
}
