% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitionBundle_method.R
\docType{methods}
\name{partitionBundle}
\alias{partitionBundle}
\alias{partitionBundle,partition-method}
\alias{partitionBundle,character-method}
\alias{partitionBundle,context-method}
\title{Generate a bundle of partitions}
\usage{
partitionBundle(.Object, ...)

\S4method{partitionBundle}{partition}(.Object, sAttribute, values = NULL,
  prefix = c(""), mc = getOption("polmineR.mc"), verbose = TRUE,
  progress = FALSE, ...)

\S4method{partitionBundle}{character}(.Object, sAttribute, values = NULL,
  prefix = c(""), mc = getOption("polmineR.mc"), verbose = TRUE,
  progress = FALSE, ...)

\S4method{partitionBundle}{context}(.Object, mc = getOption("polmineR.mc"),
  verbose = FALSE, progress = TRUE)
}
\arguments{
\item{.Object}{character string, a partition, or a list}

\item{...}{parameters to be passed into partition-method (see respective documentation)}

\item{sAttribute}{the s-attribute to vary}

\item{values}{values the s-attribute provided shall assume}

\item{prefix}{a character vector that will be attached as a prefix to partition names}

\item{mc}{logical, whether to use multicore parallelization}

\item{verbose}{logical, whether to provide progress information}

\item{progress}{logical, whether to show progress bar}
}
\value{
S4 class 'partitionBundle', with list of partition objects in slot 'objects'
}
\description{
A partitionBundle object is a S4 class object. 
partitionBundle,character-method will create a bundle of partitions,
but not yet enriched.
}
\examples{
\dontrun{
  use("polmineR.sampleCorpus")
  bt2009 <- partition("PLPRBTTXT", text_year = "2009")
  pBundle <- partitionBundle(bt2009, sAttribute = "text_date", progress = TRUE, pAttribute = "word")
  dtm <- as.DocumentTermMatrix(pBundle, col = "count")
  summary(pBundle)
  btBundle <- partitionBundle("PLPRBTTXT", sAttribute = "text_date")
}
}
\seealso{
\code{\link{partition}} and \code{\link{bundle-class}}
}
\author{
Andreas Blaette
}
