% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R
\docType{class}
\name{subcorpus-class}
\alias{subcorpus-class}
\alias{show,subcorpus-method}
\title{S4 subcorpus class.}
\usage{
\S4method{show}{subcorpus}(object)
}
\arguments{
\item{object}{A \code{subcorpus} object.}
}
\description{
S4 subcorpus class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Output basic information about \code{subcorpus} object.
}}

\section{Slots}{

\describe{
\item{\code{s_attributes}}{A named \code{list} with the structural attributes
defining the subcorpus.}

\item{\code{cpos}}{A \code{matrix} with left and right corpus positions defining
regions (two columns).}

\item{\code{annotations}}{Object of class \code{list}.}

\item{\code{size}}{Total size of the subcorpus (length-one \code{integer} vector).}

\item{\code{metadata}}{Object of class \code{data.frame}, metadata information.}

\item{\code{strucs}}{Object of class \code{integer}, the strucs defining the
subcorpus.}

\item{\code{xml}}{Object of class \code{character}, whether the xml is "flat" or
"nested".}

\item{\code{s_attribute_strucs}}{Object of class \code{character}, the base node.}

\item{\code{key}}{Experimental, an s-attribute that is used as a key.}
}}

\seealso{
Other classes to manage corpora: \code{\link{corpus-class}},
  \code{\link{regions}}
}
\concept{classes to manage corpora}
