% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\docType{methods}
\name{dispersion}
\alias{dispersion}
\alias{dispersion,partition-method}
\alias{dispersion,character-method}
\alias{dispersion,hits-method}
\title{Dispersion of a query or multiple queries}
\usage{
dispersion(.Object, ...)

\S4method{dispersion}{partition}(.Object, query, s_attribute,
  cqp = FALSE, p_attribute = getOption("polmineR.p_attribute"),
  freq = FALSE, mc = FALSE, progress = TRUE, verbose = FALSE, ...)

\S4method{dispersion}{character}(.Object, query, s_attribute,
  cqp = is.cqp, p_attribute = getOption("polmineR.p_attribute"),
  freq = FALSE, mc = FALSE, progress = TRUE, verbose = TRUE, ...)

\S4method{dispersion}{hits}(.Object, s_attribute, freq = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{.Object}{a partition object}

\item{...}{further parameters}

\item{query}{a character vector containing one or multiple queries}

\item{s_attribute}{a character vector of length 1 or 2 providing the s-attributes}

\item{cqp}{if logical, whether the query is a CQP query (TRUE/FALSE), if it is a function that is passed in, the function will be applied to the query to guess whether query is a CQP query}

\item{p_attribute}{the p-attribute that will be looked up, typically 'word'
or 'lemma'}

\item{freq}{logical, whether to calculate normalized frequencies}

\item{mc}{logical, whether to use multicore}

\item{progress}{logical, whether to shop progress}

\item{verbose}{logical, whether to be verbose}
}
\value{
depends on the input, as this is a wrapper function
}
\description{
The function returns the frequencies of a query or a multiple queries
in sub-partitions defined by one or two dimensions. This is a wrapper function, so the output will depend
on the number of queries and dimensions provided.
}
\examples{
use("polmineR")
test <- partition("GERMAPARLMINI", date = ".*", p_attribute = NULL, regex = TRUE)
integration <- dispersion(
  test, query = "Integration",
  p_attribute = "word", s_attribute = "date"
)
integration <- dispersion(test, "Integration", s_attribute = c("date", "party"))
integration <- dispersion(test, '"Integration.*"', s_attribute = "date", cqp = TRUE)
}
\seealso{
\code{crosstab-class}

count
}
\author{
Andreas Blaette
}
