% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_method.R
\docType{methods}
\name{encode,data.frame-method}
\alias{encode,data.frame-method}
\title{Encode CWB Corpus.}
\usage{
\S4method{encode}{data.frame}(.Object, name, pAttributes = "word",
  sAttributes = NULL, registry = Sys.getenv("CORPUS_REGISTRY"),
  indexedCorpusDir = NULL, verbose = TRUE)
}
\arguments{
\item{.Object}{a data.frame to encode}

\item{name}{name of the (new) CWB corpus}

\item{pAttributes}{columns of .Object with tokens (such as word/pos/lemma)}

\item{sAttributes}{columns of .Object that will be encoded as structural attributes}

\item{registry}{path to the corpus registry}

\item{indexedCorpusDir}{directory where to create directory for indexed corpus files}

\item{verbose}{logical, whether to be verbose}
}
\description{
Encode CWB Corpus.
}
\examples{
\dontrun{
library(tm)
library(tibble)
library(tidytext)
library(plyr)
reut21578 <- system.file("texts", "crude", package = "tm")
reuters.tm <- VCorpus(DirSource(reut21578), list(reader = readReut21578XMLasPlain))
reuters.tibble <- tidy(reuters.tm)
# reuters.tibble[["topics_cat"]] <- sapply(
  reuters.tibble[["topics_cat"]],
  function(x) paste(x, collapse = "|")
)
reuters.tibble[["places"]] <- sapply(
 reuters.tibble[["places"]],
 function(x) paste(x, collapse = "|")
)
reuters.tidy <- unnest_tokens(
  reuters.tibble, output = "word", input = "text", to_lower = FALSE
  )
encode(reuters.tidy, name = "reuters", sAttributes = c("language", "places"))
}
}

