% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moeWaveCrosstab.R
\name{moe_wave_crosstab}
\alias{moe_wave_crosstab}
\title{weighted crosstabs with margin of error, where the x-variable identifies different survey waves}
\usage{
moe_wave_crosstab(
  df,
  x,
  y,
  weight,
  remove = c(""),
  n = TRUE,
  pct_type = "row",
  format = "long",
  zscore = 1.96,
  unwt_n = FALSE
)
}
\arguments{
\item{df}{The data source}

\item{x}{The independent variable, which uniquely identifies survey waves}

\item{y}{The dependent variable}

\item{weight}{The weighting variable, defaults to zwave_weight}

\item{remove}{An optional character vector of values to remove from final table (e.g. "refused").
This will not affect any calculations made. The vector is not case-sensitive.}

\item{n}{logical, if TRUE numeric totals are included.}

\item{pct_type}{Controls the kind of percentage values returned. One of "row" or "cell."
Column percents are not supported.}

\item{format}{one of "long" or "wide"}

\item{zscore}{defaults to 1.96, consistent with a 95\% confidence interval}

\item{unwt_n}{logical, if TRUE it adds a column with unweighted frequency values}
}
\value{
a tibble
}
\description{
\code{moe_wave_crosstab} returns a tibble containing a weighted crosstab of two variables
 with margin of error. Use this function when the x-variable indicates different survey
 waves for which weights were calculated independently.
}
\details{
Options  include row or cell percentages. The tibble can be in long or wide format. The margin of
 error includes the design effect of the weights, calculated separately for each
 survey wave.
}
\examples{
moe_wave_crosstab(df = illinois, x = year, y = maritalstatus, weight = weight)
moe_wave_crosstab(df = illinois, x = year, y = maritalstatus, weight = weight, format = "wide")
}
