% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/polls.R
\name{pollstr_polls}
\alias{pollstr_polls}
\title{Get a list of polls}
\usage{
pollstr_polls(page = 1, chart = NULL, state = NULL, topic = NULL,
  before = NULL, after = NULL, sort = FALSE, showall = NULL,
  max_pages = 1, convert = TRUE)
}
\arguments{
\item{page}{Return page number}

\item{chart}{List polls related to the specified chart. Chart names are the \code{slug} returned by \code{pollstr_charts}.}

\item{state}{Only include charts from a single state. Use 2-letter pstate abbreviations. "US" will return all national charts.}

\item{topic}{Only include charts related to a specific topic. See the \url{http://elections.huffingtonpost.com/pollster/api} for examples.}

\item{before}{Only list polls that ended on or bfore the specified date.}

\item{after}{Only list polls that ended on or bfore the specified date.}

\item{sort}{If \code{TRUE}, then sort polls by the last updated time.}

\item{showall}{Include polls for races that were once possible but didn't happen (e.g. Gingrich vs. Obama 2012)}

\item{max_pages}{Maximum number of pages to get.}

\item{convert}{Rearrange the data returned by the API into easier to use data frames.}
}
\value{
If \code{convert=TRUE}, a \code{"pollstr_polls"} object with elements
\describe{
\item{\code{polls}}{A \code{data.frame} with entries for each poll.}
\item{\code{questions}}{A \code{data.frame} with entries for each question asked in the polls.}
\item{\code{survey_houses}}{A \code{data.frame} with the survey houses of the polls. There can be multiple survey houses for a poll.}
\item{\code{sponsors}}{A \code{data.frame} with the sponsors of the polls. Not all polls have sponsors.}
}
Otherwise, a \code{"list"} in the original structure of the json returned by the API.
}
\description{
Get a list of polls
}
\examples{
\dontrun{
# Get polls related to a chart pulled programmatically with
# pollstr_charts()
all_charts <- pollstr_charts()
pollstr_polls(chart=all_charts$slug[1])
# Lookup polls related to a specific topic
pollstr_polls(topic='2016-president')
}
}
\references{
\url{http://elections.huffingtonpost.com/pollster/api}
}

