% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdd.R
\name{gdd}
\alias{gdd}
\title{Growing Degree Days Function}
\usage{
gdd(x, tmax, tmin, tbase, tbase_max)
}
\arguments{
\item{x}{data.frame object containing the data}

\item{tmax}{daily maximum temperature}

\item{tmin}{daily minimum temperature}

\item{tbase}{base temperature}

\item{tbase_max}{maximum base temperature}
}
\value{
a numeric vector with GDD values
}
\description{
This function calculates growing degree days (GDD) using the average of the daily maximum
and minimum temperatures, a base temperature and a maximum base temperature
}
\examples{
set.seed(25)
df <- data.frame(tmax=runif(100, 6, 10), tmin=runif(100, 4,6))

gdd(df, tmax='tmax', tmin='tmin', tbase=5, tbase_max=30)


}
\keyword{meteo,}
\keyword{temperature}
