% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_def.R
\name{static_policy}
\alias{static_policy}
\title{Define Static Policy}
\usage{
static_policy(action, name = paste0("a=", action))
}
\arguments{
\item{action}{Character string. The static action to be applied.}

\item{name}{Name of the policy.}
}
\value{
function with arguments \code{history}. Specifically,
\code{history} is a history object, see \link{history}. When evaluated, the
function returns a \link{data.table} with keys \code{id} and \code{stage} and
action variable \code{d}.
}
\description{
\code{static_policy} defines a static policy with a given
action.
}
\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting a history object for stage 2:
his <- get_history(pd, stage = 2)

# applying the static policy at the given stage:
head(static_policy(action = 1)(his))
}
