% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyframe__lazy.R
\docType{data}
\name{LazyFrame_describe_optimized_plan}
\alias{LazyFrame_describe_optimized_plan}
\alias{LazyFrame_describe_plan}
\title{Print the optimized or non-optimized plans of \code{LazyFrame}}
\format{
An object of class \code{character} of length 1.
}
\usage{
LazyFrame_describe_optimized_plan()

LazyFrame_describe_plan
}
\value{
invisible NULL
}
\description{
\verb{$describe_plan()} shows our query in the format that \code{polars}
understands. \verb{$describe_optimized_plan()} shows the optimized query plan that
\code{polars} will execute when \verb{$collect()} or \verb{$compute()} is called. It is possible
that both plans are identical if \code{polars} doesn't find any way to optimize the
query.
}
\examples{
my_file = tempfile()
write.csv(iris, my_file)

# Read the file and make a LazyFrame
lazy_frame = pl$scan_csv(path = my_file)

# Prepare your query
lazy_query = lazy_frame$sort("Species")$filter(pl$col("Species") != "setosa")

# This is the query as `polars` understands it
lazy_query$describe_plan()

# This is the query after `polars` optimizes it: instead of sorting first and
# then filtering, it is faster to filter first and then sort the rest.
lazy_query$describe_optimized_plan()
}
\keyword{LazyFrame}
\keyword{datasets}
